/*************************************************
author: RuanShengQiang
date: 2017/3/24
**************************************************/
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

static vec2 myMod(vec2 x, float y)
{
	return x-y * floor (x/y);
}

//to amp "amp" times the picture;
static vec2 scale(vec2 uv, float amp)
{

	return myMod((uv + (vec2)(0.5f))*(amp), 1.0f);

}
static vec2 _rotate(vec2 uv, vec2 center, float theta)
{
	vec2 temp;
	temp.x = dot((vec2)(cos(theta), -sin(theta)), uv - center);
	temp.y = dot((vec2)(sin(theta), cos(theta)), uv - center);
	return(temp);
}

static vec2 warp(vec2 uv, vec2 center, float strength, float r, float amp)
{

	return myMod(center + (uv - center) / (strength*r*r + strength*r + 1.0f), 1.0f / amp);
}

static vec2 mirror(vec2 uv)
{
	vec2 parity = myMod(floor(uv),2.0f);
	vec2 sign = -2.0f*parity+1.0f;
	return myMod( 2.0f*parity+sign*myMod(uv,1.0f),1.0f);
}

static vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

static float4 blur(image2d_t input, __global FilterParam* param, vec2 uv, vec2 dir, int Samples, float processMB, vec2 rollDir)
{
	vec2 temp1;
	vec2 temp2;
	vec2 temp3;
	float2 diver = dir*processMB/(float)(Samples);
	vec4 color = (vec4)(0.0f,0.0f,0.0f,1.0f);
	for (int i = 0; i < Samples; i += 2) //operating at 2 samples for better performance
	{
		temp1 = mirror( uv + (float)(i) * diver +rollDir );
		color += INPUT(input, param, temp1);
		temp1 = mirror( uv + (float)(i+1) * diver +rollDir );
		color += INPUT(input, param, temp1);
	}
	return color;
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	float prop = resolution.y / resolution.x;
	float iGlobalTime = progress;
	
	const float sampleSize = 32.0f;
	const int Samples = 16;//multiple of 2

	vec2 center = (vec2)(1.0f,0.0f);
	vec2 dir = (vec2)(0.0f,1.0f);
	float r = length(dir);
	
	float processColorSp = pow(cos(PI*(iGlobalTime-0.5f)),2.0f)*0.01f;
	float processMB = iGlobalTime*0.5f;// the blur trend is same as scale
	float rotateDeta = PI/180.0f*(-45.0f);
	
	float temp = cos(PI*3.0f/2.0f*(iGlobalTime-0.33333f));
	vec2 rollDir = 0.5f*(vec2)(0.0f,temp*temp);
	
	float processMBR= 0.0f;//1.0*(iGlobalTime-1.0)*(iGlobalTime-1.0);
	
if (iGlobalTime<0.2f)
    { 	
		rollDir =  (vec2)( 0.0f,1.0f- pow(fabs(sin(PI/2.0f*(5.2f*(iGlobalTime-1.0f/5.2f)))),0.5f) );
		processMB = clamp(rollDir.y,-0.3f,0.3f);
		processColorSp = clamp(rollDir.y*0.1f,-0.001f,0.001f);
		rollDir= _rotate(rollDir, (vec2)(0.0f),rotateDeta)/1.414f;
		dir= _rotate(dir, (vec2)(0.0f),rotateDeta);
		vec4 color = globalBlur(input1, param, uv, dir,Samples, processMB,rollDir, resolution);
		write_imagef(dstImg, (int2)(w, textH - h -1), color/(float)(Samples));
    }
	else {
		if(iGlobalTime<0.4f)//0.3-0.6
		{
			rollDir = (vec2)( 0.0f,5.0f*iGlobalTime-2.0f)*2.5f;
			rollDir= _rotate(rollDir, (vec2)(0.0f),rotateDeta)/1.414f;
			dir= _rotate(dir, (vec2)(0.0f),rotateDeta);
			processMBR = 0.05f;
			processColorSp =0.001f;
			vec4 color = globalBlur(input2, param, uv, dir,Samples, processMBR,rollDir, resolution);
			write_imagef(dstImg, (int2)(w, textH - h -1), color/(float)(Samples));
		}else// >0.6
		{
			rollDir = (vec2)( 0.0f,4.0f*(iGlobalTime-0.4f)*exp(-14.0f*(iGlobalTime-0.4f)));
			processMBR =( 4.0f*exp(-14.0f*(iGlobalTime-0.4f)) -56.0f*(iGlobalTime-0.4f)*exp(-14.0f*(iGlobalTime-0.4f)) )*0.01f;
			processColorSp = 0.0f;
			rollDir= _rotate(rollDir, (vec2)(0.0f),rotateDeta)/1.414f;
			dir= _rotate(dir, (vec2)(0.0f),rotateDeta);
			vec4 color = globalBlur(input2, param, uv, dir,Samples, processMBR,rollDir, resolution);
			write_imagef(dstImg, (int2)(w, textH - h -1), color/(float)(Samples));
		}
		//return INPUT2(uv);
	}
}